/*
 * Decompiled with CFR 0.152.
 */
package tetrisfx;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.GroupBuilder;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SceneBuilder;
import javafx.scene.control.Label;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.media.AudioClip;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.util.Duration;
import tetrisfx.Tetromino;

public class TetrisFX
extends Application {
    public static final int GRID_WIDTH = 10;
    public static final int GRID_HEIGHT = 20;
    public static final int INITIAL_SCORE = 0;
    public static final int INITIAL_LINES = 0;
    public static final int INITIAL_LEVEL = 1;
    public static final int LEVEL_INCREASE = 10;
    public static final String MEDIA_DIR = "sounds/";
    public static final int WINDOW_HEIGHT = 644;
    public static final int WINDOW_WIDTH = 678;
    private Scene scene;
    Timeline gameTimeline = new Timeline();
    private Group gridGroup = new Group();
    private final IntegerProperty score = new SimpleIntegerProperty(0);
    private final IntegerProperty lines = new SimpleIntegerProperty(0);
    private final IntegerBinding level = this.lines.divide(10).add(1);
    private final BooleanProperty gameOver = new SimpleBooleanProperty(false);
    private final BooleanProperty gamePaused = new SimpleBooleanProperty(false);
    public List<Tetromino.Square[]> grid = new ArrayList<Tetromino.Square[]>();
    private List<Tetromino> upcomingTetrominos = new ArrayList<Tetromino>();
    private List<Tetromino.Shape> tetrominos;
    private Rectangle menuContainer;
    private Group tetrominoGroup;
    private Group lookOutGroup;
    private Group gameOverGroup;
    private Group pausedGroup;
    private MediaPlayer backgroundSound;
    private Map<String, AudioClip> soundMap = new HashMap<String, AudioClip>();
    private int millis;
    private int[] framesPerRow = new int[]{53, 49, 45, 41, 37, 33, 28, 22, 17, 11, 10, 9, 8, 7, 6, 6, 5, 5, 4, 4, 3};
    private EventHandler<ActionEvent> kfeh = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (TetrisFX.this.millis++ < TetrisFX.this.getFramesPerLevel()) {
                return;
            }
            TetrisFX.this.millis = 0;
            Tetromino t = (Tetromino)((Object)TetrisFX.this.tetrominoGroup.getChildren().get(0));
            Point pos = t.getPosition();
            if (!t.translate(0, 1)) {
                TetrisFX.this.gridGroup.getChildren().add((Object)t);
                for (int i = 0; i < 4; ++i) {
                    Tetromino.Square s = t.squares.get(i);
                    s.setTranslateX(pos.x * 30 + 22);
                    s.setTranslateY(pos.y * 30 + 22);
                    Point coords = t.getCoords(i);
                    TetrisFX.this.setSquare(s, 19 - (pos.y + coords.y), pos.x + coords.x);
                }
                TetrisFX.this.tetrominoGroup.getChildren().remove((Object)t);
                TetrisFX.this.upcomingTetrominos.remove(0);
                if (TetrisFX.this.upcomingTetrominos.size() <= 1) {
                    TetrisFX.this.addRandomizedTetrominos();
                }
                Tetromino te = (Tetromino)((Object)TetrisFX.this.upcomingTetrominos.get(0));
                for (int[] coord : te.coords) {
                    try {
                        if (TetrisFX.this.grid.get(19 - te.position.y + coord[1])[te.position.x + coord[0]] == null) continue;
                        TetrisFX.this.gameOver();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                TetrisFX.this.tetrominoGroup.getChildren().add(TetrisFX.this.upcomingTetrominos.get(0));
                TetrisFX.this.lookOutGroup.getChildren().remove(TetrisFX.this.upcomingTetrominos.get(0));
                TetrisFX.this.lookOutGroup.getChildren().add(TetrisFX.this.upcomingTetrominos.get(1));
            }
            TetrisFX.this.removeFullLines();
        }
    };

    private int getFramesPerLevel() {
        if (this.level.getValue() - 1 >= this.framesPerRow.length) {
            return 3;
        }
        return this.framesPerRow[this.level.getValue() - 1];
    }

    public void start(Stage primaryStage) {
        primaryStage.setTitle("TetrisFX");
        primaryStage.setResizable(false);
        Group layout = new Group();
        Rectangle leftBox = new Rectangle(14.0, 14.0, 316.0, 616.0);
        leftBox.setFill((Paint)Color.TRANSPARENT);
        leftBox.setStrokeWidth(4.0);
        leftBox.setStroke((Paint)Color.BLACK);
        Rectangle rightUpperBox = new Rectangle(348.0, 14.0, 316.0, 316.0);
        rightUpperBox.setFill((Paint)Color.TRANSPARENT);
        rightUpperBox.setStrokeWidth(4.0);
        rightUpperBox.setStroke((Paint)Color.BLACK);
        Rectangle rightLowerBox = new Rectangle(348.0, 344.0, 316.0, 286.0);
        rightLowerBox.setFill((Paint)Color.TRANSPARENT);
        rightLowerBox.setStrokeWidth(4.0);
        rightLowerBox.setStroke((Paint)Color.BLACK);
        Rectangle cover = new Rectangle(0.0, 0.0, 345.0, 12.0);
        cover.setFill((Paint)Color.WHITE);
        this.initializeTextAndMenus();
        this.gridGroup.effectProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.gameOver.or((ObservableBooleanValue)this.gamePaused)).then((Object)new GaussianBlur()).otherwise((Object)null));
        this.backgroundSound = new MediaPlayer(new Media(TetrisFX.class.getResource("sounds/music_a_fast.wav").toString()));
        this.backgroundSound.setCycleCount(-1);
        this.backgroundSound.play();
        this.soundMap.put("rotate", new AudioClip(TetrisFX.class.getResource("sounds/dew.wav").toString()));
        this.soundMap.put("dropDown", new AudioClip(TetrisFX.class.getResource("sounds/ph.wav").toString()));
        this.soundMap.put("rowExplosion", new AudioClip(TetrisFX.class.getResource("sounds/didididi.wav").toString()));
        this.soundMap.put("move", new AudioClip(TetrisFX.class.getResource("sounds/did.wav").toString()));
        this.soundMap.put("pause", new AudioClip(TetrisFX.class.getResource("sounds/pause.wav").toString()));
        this.soundMap.put("gameOver", new AudioClip(TetrisFX.class.getResource("sounds/applaus.wav").toString()));
        this.tetrominoGroup = new Group();
        this.lookOutGroup = new Group();
        this.lookOutGroup.setTranslateX(340.0);
        this.lookOutGroup.setTranslateY(200.0);
        this.tetrominoGroup.effectProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.gameOver.or((ObservableBooleanValue)this.gamePaused)).then((Object)new GaussianBlur()).otherwise((Object)null));
        this.tetrominos = new ArrayList<Tetromino.Shape>(Arrays.asList(Tetromino.Shape.values()));
        this.addRandomizedTetrominos();
        this.tetrominoGroup.getChildren().add((Object)this.upcomingTetrominos.get(0));
        this.lookOutGroup.getChildren().add((Object)this.upcomingTetrominos.get(1));
        this.lookOutGroup.effectProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.gameOver.or((ObservableBooleanValue)this.gamePaused)).then((Object)new GaussianBlur()).otherwise((Object)null));
        for (int i = 0; i < 20; ++i) {
            this.grid.add(new Tetromino.Square[10]);
        }
        Label information = new Label();
        information.setFont(new Font(24.0));
        information.setTextFill((Paint)Color.BLACK);
        information.textProperty().bind((ObservableValue)Bindings.format((String)"Score: %s\nLines: %s\nLevel: %s\n\nNext stone:", (Object[])new Object[]{this.score, this.lines, this.level}));
        information.setTranslateX(358.0);
        information.setTranslateY(24.0);
        Label controlInformation = new Label();
        controlInformation.setFont(new Font(18.0));
        controlInformation.setTextFill((Paint)Color.BLACK);
        controlInformation.textProperty().set((Object)"Controls:\n  Left/Right:\tmove left/right\n  Up/Space:\trotate\n  Enter:\t\tdrop down\n  Escape:\t\tpause\n");
        controlInformation.setTranslateX(358.0);
        controlInformation.setTranslateY(358.0);
        this.scene = SceneBuilder.create().width(678.0).height(644.0).root((Parent)GroupBuilder.create().children(new Node[]{leftBox, rightUpperBox, rightLowerBox, this.gridGroup, this.tetrominoGroup, information, this.lookOutGroup, controlInformation, cover, this.menuContainer, this.gameOverGroup, this.pausedGroup}).build()).build();
        this.scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                Tetromino t = (Tetromino)((Object)TetrisFX.this.tetrominoGroup.getChildren().get(0));
                if (event.getCode() == KeyCode.RIGHT && !TetrisFX.this.gameOver.getValue().booleanValue() && !TetrisFX.this.gamePaused.getValue().booleanValue()) {
                    ((AudioClip)TetrisFX.this.soundMap.get("move")).play();
                    t.translate(1, 0);
                }
                if (event.getCode() == KeyCode.LEFT && !TetrisFX.this.gameOver.getValue().booleanValue() && !TetrisFX.this.gamePaused.getValue().booleanValue()) {
                    ((AudioClip)TetrisFX.this.soundMap.get("move")).play();
                    t.translate(-1, 0);
                }
                if (event.getCode() == KeyCode.SPACE && !TetrisFX.this.gameOver.getValue().booleanValue() && !TetrisFX.this.gamePaused.getValue().booleanValue()) {
                    ((AudioClip)TetrisFX.this.soundMap.get("rotate")).play();
                    t.rotate();
                }
                if (event.getCode() == KeyCode.UP && !TetrisFX.this.gameOver.getValue().booleanValue() && !TetrisFX.this.gamePaused.getValue().booleanValue()) {
                    ((AudioClip)TetrisFX.this.soundMap.get("rotate")).play();
                    t.rotate();
                }
                if (event.getCode() == KeyCode.DOWN && !TetrisFX.this.gameOver.getValue().booleanValue() && !TetrisFX.this.gamePaused.getValue().booleanValue()) {
                    ((AudioClip)TetrisFX.this.soundMap.get("move")).play();
                    t.translate(0, 1);
                }
                if (event.getCode() == KeyCode.ENTER && !TetrisFX.this.gameOver.getValue().booleanValue() && !TetrisFX.this.gamePaused.getValue().booleanValue()) {
                    ((AudioClip)TetrisFX.this.soundMap.get("dropDown")).play();
                    t.dropDown();
                }
                if (event.getCode() == KeyCode.N && TetrisFX.this.gameOver.getValue().booleanValue()) {
                    TetrisFX.this.gameRestart();
                }
                if (event.getCode() == KeyCode.ESCAPE && !TetrisFX.this.gameOver.getValue().booleanValue()) {
                    ((AudioClip)TetrisFX.this.soundMap.get("pause")).play();
                    TetrisFX.this.pauseGame();
                }
            }
        });
        this.gameTimeline.setCycleCount(-1);
        this.gameTimeline.getKeyFrames().add(0, (Object)new KeyFrame(Duration.millis((double)17.0), this.kfeh, new KeyValue[0]));
        this.gameTimeline.play();
        primaryStage.setScene(this.scene);
        primaryStage.show();
    }

    private void initializeTextAndMenus() {
        this.menuContainer = new Rectangle(189.0, 172.0, 300.0, 300.0);
        this.menuContainer.setFill((Paint)Color.WHITE);
        this.menuContainer.setStroke((Paint)Color.BLACK);
        this.menuContainer.setVisible(false);
        Label goInformation = new Label();
        goInformation.setFont(new Font(24.0));
        goInformation.setTextFill((Paint)Color.BLACK);
        goInformation.textProperty().bind((ObservableValue)Bindings.format((String)"Game Over!\n\nResults:\n\tScore: %s\n\tLines: %s\n\tLevel: %s\n\npress \"n\" to restart!", (Object[])new Object[]{this.score, this.lines, this.level}));
        goInformation.setTranslateX(204.0);
        goInformation.setTranslateY(187.0);
        Label pauseTitle = new Label();
        pauseTitle.setFont(new Font(24.0));
        pauseTitle.setTextFill((Paint)Color.BLACK);
        pauseTitle.setText("game paused");
        pauseTitle.setTranslateX(189.0);
        pauseTitle.setTranslateY(272.0);
        pauseTitle.setMinWidth(300.0);
        pauseTitle.setAlignment(Pos.CENTER);
        Label pauseSubTitle = new Label();
        pauseSubTitle.setFont(new Font(16.0));
        pauseSubTitle.setTextFill((Paint)Color.BLACK);
        pauseSubTitle.setText("to unpause press escape");
        pauseSubTitle.setTranslateX(189.0);
        pauseSubTitle.setTranslateY(337.0);
        pauseSubTitle.setMinWidth(300.0);
        pauseSubTitle.setAlignment(Pos.CENTER);
        this.pausedGroup = new Group();
        this.pausedGroup.getChildren().add((Object)pauseTitle);
        this.pausedGroup.getChildren().add((Object)pauseSubTitle);
        this.pausedGroup.setVisible(false);
        this.gameOverGroup = new Group();
        this.gameOverGroup.getChildren().add((Object)goInformation);
        this.gameOverGroup.setVisible(false);
    }

    private void pauseGame() {
        if (!this.gamePaused.getValue().booleanValue()) {
            this.gamePaused.set(true);
            this.gameTimeline.stop();
            this.pausedGroup.setVisible(true);
            this.menuContainer.setVisible(true);
        } else {
            this.gamePaused.set(false);
            this.gameTimeline.play();
            this.pausedGroup.setVisible(false);
            this.menuContainer.setVisible(false);
        }
    }

    private void gameRestart() {
        this.grid.clear();
        for (int i = 0; i < 20; ++i) {
            this.grid.add(new Tetromino.Square[10]);
        }
        this.gameTimeline.play();
        this.gridGroup.getChildren().clear();
        this.gameOver.set(false);
        this.menuContainer.setVisible(false);
        this.gameOverGroup.setVisible(false);
        this.score.set(0);
        this.lines.set(0);
    }

    private void gameOver() {
        this.soundMap.get("gameOver").play();
        this.gameOver.set(true);
        this.menuContainer.setVisible(true);
        this.gameOverGroup.setVisible(true);
        this.gameTimeline.stop();
    }

    public void setSquare(Tetromino.Square square, int r, int c) {
        this.gridGroup.getChildren().add((Object)square);
        try {
            this.grid.get((int)r)[c] = square;
        }
        catch (Exception e) {
            this.grid.add(r, new Tetromino.Square[10]);
        }
    }

    public static void main(String[] args) {
        TetrisFX.launch((String[])args);
    }

    public void removeFullLines() {
        int multiple = 0;
        for (int i = 0; i < this.grid.size(); ++i) {
            int j;
            Tetromino.Square[] array = this.grid.get(i);
            boolean full = true;
            for (j = 0; j < 10; ++j) {
                if (array[j] != null) continue;
                full = false;
            }
            if (!full) continue;
            for (Tetromino.Square s : this.grid.get(i)) {
                s.setFill((Paint)Color.TRANSPARENT);
                s.setStroke((Paint)Color.TRANSPARENT);
            }
            for (j = i; j < this.grid.size() - 1; ++j) {
                this.grid.set(j, this.grid.get(j + 1));
                for (Tetromino.Square s : this.grid.get(j + 1)) {
                    if (s == null) continue;
                    s.setTranslateY(s.getTranslateY() + 30.0);
                }
            }
            this.grid.set(this.grid.size() - 1, new Tetromino.Square[10]);
            ++multiple;
            --i;
        }
        if (multiple > 0) {
            this.soundMap.get("rowExplosion").play();
        }
        this.lines.set(this.lines.get() + multiple);
        int scoreBonus = 0;
        switch (multiple) {
            case 1: {
                scoreBonus = 40 * this.level.get();
                break;
            }
            case 2: {
                scoreBonus = 100 * this.level.get();
                break;
            }
            case 3: {
                scoreBonus = 300 * this.level.get();
                break;
            }
            case 4: {
                scoreBonus = 1200 * this.level.get();
            }
        }
        this.score.set(this.score.get() + scoreBonus);
    }

    private void addRandomizedTetrominos() {
        Collections.shuffle(this.tetrominos);
        for (Tetromino.Shape s : this.tetrominos) {
            this.upcomingTetrominos.add(new Tetromino(this, s));
        }
    }
}

